/************************************************************/
/* PROJECT NAME: SWI	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin                                   */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     GCC ARM port			                    */
/* Assembler:    As  ARM port	                            */
/*                                                          */
/************************************************************/
/* Modification History:                                    */
/*                                                          */
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example software interrupt for LPC2100              		*/
/*															*/
/* Demonstrates serving an SWI and running selected code	*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB21000								*/
/************************************************************/


#define SoftwareInterrupt1 asm (" swi #01")				//define macro to generate and SWI with ordinal 0x02

#define SoftwareInterrupt2 

#define SoftwareInterrupt3 asm (" swi #03")

#include <LPC21xx.H> 


	
void SWI_ISR(void) __attribute__ ((interrupt("SWI")));

int main(void)
{
IODIR1 = 0x00FF0000;									//Set LED pins as outputs
IOCLR1 = 0x00FF0000;

SoftwareInterrupt1;										//Generate software interrupt
SoftwareInterrupt2;
SoftwareInterrupt3;

while(1)
{
;														//Loop forever
}
}


void SWI_ISR(void)
{
unsigned * link_ptr ;				//Create a pointer to the link register
unsigned temp = 0;										//Local dummy variable 
temp = ;						// Read return address - 4 bytes (SWI instruction) mask off top 8 bits - gives ordinal 

switch ( temp)											// Switch to requested code and set LED pattern
{

case 0x01 :
			IOCLR1 = 0x00FF0000;
			IOSET1 = 0x00010000;						
			break;
case 0x02 : 
			IOCLR1 = 0x00FF0000;
			IOSET1 = 0x00020000;
			break;
case 0x03 : 
			IOCLR1 = 0x00FF0000;
			IOSET1 = 0x00040000;
			break;
default:
			break;
}

}

